<?php

/** @var  \Herbert\Framework\Application $container */
/** @var  \Herbert\Framework\Http $http */
/** @var  \Herbert\Framework\Router $router */
/** @var  \Herbert\Framework\Enqueue $enqueue */
/** @var  \Herbert\Framework\Panel $panel */
/** @var  \Herbert\Framework\Shortcode $shortcode */
/** @var  \Herbert\Framework\Widget $widget */

use Illuminate\Database\Capsule\Manager as Capsule;

Capsule::schema()->drop('connections');
Capsule::schema()->drop('jobs');
Capsule::schema()->drop('logs');
Capsule::schema()->drop('existing_users');

$dropTriggers = [
    'DROP TRIGGER IF EXISTS sendcrux_after_users_update',
    'DROP TRIGGER IF EXISTS sendcrux_after_users_insert',
    'DROP TRIGGER IF EXISTS sendcrux_after_users_delete',
    'DROP TRIGGER IF EXISTS sendcrux_after_usermeta_update',
    'DROP TRIGGER IF EXISTS sendcrux_after_usermeta_insert',
    'DROP TRIGGER IF EXISTS sendcrux_after_usermeta_delete'
];

foreach ($dropTriggers as $sql) {
    Capsule::connection()->getPdo()->exec($sql);
}
